unit aspxDelphiWCL.Emoticon;

{

Copyright:  aspxDelphi.net All rights reserved. Use freely.

Zarko Gajic
http://aspxdelphi.net
http://delphi.about.com

}

interface

uses
  aspxDelphiWCL.ResourcesHandler, System.Text, aspxDelphiWCL.Common,
  aspxDelphiWCL.Designer, aspxDelphiWCL.RadioButonListItemAttributes,
  System.Web.UI, System.Web.UI.WebControls,
  System.ComponentModel;

type
  MoodType = (Smile, Confused, Crying, Eye_Rolling, Not_Sure);//, Cannot_Tell, Sad, Smile, Surprised, Thinking, Wink);

  /// <summary>
  /// Emoticon enables a user to select its mood with graphical representation
  /// </summary>
  [
  DefaultProperty('Text')
	,DesignerAttribute(typeof(aspxDelphiWCL.Designer.Designer))
  ,ToolboxData('<{0}:Emoticon runat=server></{0}:Emoticon>')
  ]
  Emoticon = class(System.Web.UI.WebControls.WebControl, INamingContainer)
  strict private
    type MoodHelper = class
    private
      FDescription: string;
      FCode: string;
      FImageName: string;
    public
      property Description : string read FDescription;  //MUST BE UNIQUE FROM EACH INSTANCE!!!
      property Code : string  read FCode;
      property ImageName : string read FImageName;
    end;

    type MoodHelperArray = array [MoodType] of MoodHelper;
  strict private
    MoodList : RadioButonListItemAttributes;
    MoodDesignText : &Label; //displayed at design time
    MoodImage : Image; //displayed at run time

    EmoticonMoods : MoodHelperArray;

    procedure FillEmoticonMoods;
    procedure MoodList_AttachAttributes;
  strict protected
    procedure CreateChildControls; override;
    procedure OnInit(e: EventArgs); override;
    procedure OnPreRender(e: EventArgs); override;
    procedure Render(writer: HtmlTextWriter); override;
    procedure AddAttributesToRender(writer: HtmlTextWriter); override;
  public
    constructor Create;
    function get_Controls :  System.Web.UI.ControlCollection; override;
    function GetMood: Moodtype;
    procedure SetMood(const Value: Moodtype);
  published
    [
    Category('Appearance')
    ,DefaultValue(typeof(MoodType), 'Smile')
    ]
    property Mood: MoodType read GetMood write SetMood;
  end;

implementation

{$REGION 'Create, Init, Load'}
constructor Emoticon.Create;
begin
  inherited Create(HtmlTextWriterTag.Table);

  FillEmoticonMoods;
end;

procedure Emoticon.OnInit(e: EventArgs);
begin
  inherited;


end;
{$ENDREGION}

{$REGION 'Public properties'}
function Emoticon.GetMood: MoodType;
  function MoodFromDescription(Description : string) : MoodType;
  var
    mt : MoodType;
  begin
    Result := MoodType.Smile; // only to disable "undefined return" warning
    for mt := Low(EmoticonMoods) to High(EmoticonMoods) do
    begin
      if EmoticonMoods[mt].Description = Description then
      begin
        Result := mt;
        Exit;
      end;
    end;
  end;
begin
  EnsureChildControls;

  Result := MoodFromDescription(MoodList.SelectedItem.Text);
end;

procedure Emoticon.SetMood(const Value: MoodType);
begin
  EnsureChildControls;

  MoodList.SelectedIndex := MoodList.Items.IndexOf(MoodList.Items.FindByText(EmoticonMoods[Value].Description));

  MoodDesignText.Text := EmoticonMoods[Value].Code;
end;
{$ENDREGION}

{$REGION 'Private methods'}
procedure Emoticon.FillEmoticonMoods;
begin
  EmoticonMoods[MoodType.Smile] := MoodHelper.Create;
  EmoticonMoods[MoodType.Smile].FDescription := 'Smile';
  EmoticonMoods[MoodType.Smile].FImageName := 'smile.gif';
  EmoticonMoods[MoodType.Smile].FCode := ':-)';

  EmoticonMoods[MoodType.Confused] := MoodHelper.Create;
  EmoticonMoods[MoodType.Confused].FDescription := 'Confused';
  EmoticonMoods[MoodType.Confused].FImageName := 'confused.gif';
  EmoticonMoods[MoodType.Confused].FCode := ':-S';

  EmoticonMoods[MoodType.Crying] := MoodHelper.Create;
  EmoticonMoods[MoodType.Crying].FDescription := 'Crying';
  EmoticonMoods[MoodType.Crying].FImageName := 'crying.gif';
  EmoticonMoods[MoodType.Crying].FCode := ':''(';

  EmoticonMoods[MoodType.Eye_Rolling] := MoodHelper.Create;
  EmoticonMoods[MoodType.Eye_Rolling].FDescription := 'Eye rolling';
  EmoticonMoods[MoodType.Eye_Rolling].FImageName := 'eye_rolling.gif';
  EmoticonMoods[MoodType.Eye_Rolling].FCode := '8-)';

  EmoticonMoods[MoodType.Not_Sure] := MoodHelper.Create;
  EmoticonMoods[MoodType.Not_Sure].FDescription := 'I''m not sure';
  EmoticonMoods[MoodType.Not_Sure].FImageName := 'notsure.gif';
  EmoticonMoods[MoodType.Not_Sure].FCode := ':^)';

  //more...
end;

procedure Emoticon.MoodList_AttachAttributes;
var
  li : ListItem;
  mh : MoodHelper;
  imgurl:string;
begin
  for mh in EmoticonMoods do
  begin
    li := MoodList.Items.FindByText(mh.Description);

    imgurl := Page.ResolveUrl(System.String.Format('{0}?{1}={2}',ResourcesHandler.HandlerURL,ResourcesHelper.ResourceMarker, mh.ImageName));
    li.Attributes.Add('emoticon_imageurl',imgurl);

    li.Attributes.Add('onclick','aspxd_emoticon_refreshimage(this,"' + MoodImage.ClientID + '");');
  end;
end;

{$ENDREGION}

{$REGION 'Controls creation'}
procedure Emoticon.CreateChildControls;
var
  tRow : TableRow;
  ListCell : TableCell;
  ImageCell : TableCell;
begin
  inherited;
  Controls.Clear;

  tRow := TableRow.Create;
  Controls.Add(tRow);

  ListCell := TableCell.Create;
  tRow.Controls.Add(ListCell);

  ImageCell := TableCell.Create;
  tRow.Controls.Add(ImageCell);

  MoodList := RadioButonListItemAttributes.Create;
  MoodList.ID:= 'ml';
  ListCell.Controls.Add(MoodList);

  MoodImage := Image.Create;
  MoodImage.ID:='mi';
  ImageCell.Controls.Add(MoodImage);

  MoodDesignText := &Label.Create;
  ImageCell.Controls.Add(MoodDesignText);


  //"bind"
  MoodList.DataSource := EmoticonMoods;
  MoodList.DataTextField := 'Description';
  MoodList.DataValueField := 'Code';
  MoodList.DataBind;


  ChildControlsCreated := true;

  //set defaults
  Mood := MoodType.Smile;
end;



function Emoticon.get_Controls: System.Web.UI.ControlCollection;
begin
  EnsureChildControls;
  Result := inherited get_Controls;
end;
{$ENDREGION}

{$REGION 'Render and related'}
procedure Emoticon.AddAttributesToRender(writer: HtmlTextWriter);
begin
  inherited;
  Self.Attributes.Add('cellpadding','0');
  Self.Attributes.Add('cellspacing','0');
end;

procedure Emoticon.OnPreRender(e: EventArgs);
var
  imageULR : string;
  resscript : string;
begin
  inherited;

  MoodList_AttachAttributes;

  imageULR := EmoticonMoods[Mood].ImageName;
  MoodImage.ImageUrl := Page.ResolveUrl(System.String.Format('{0}?{1}={2}',ResourcesHandler.HandlerURL,ResourcesHelper.ResourceMarker, imageULR));

  if NOT Page.IsClientScriptBlockRegistered(ResourcesHelper.Emoticon_Script) then
  begin
    resscript := System.String.Format('<script language="javascript" src="{0}"></script>',
    						Page.ResolveUrl(System.String.Format('{0}?{1}={2}',
		    		    		ResourcesHandler.HandlerURL,
				    		    ResourcesHelper.ResourceMarker,
        						ResourcesHelper.Emoticon_Script
				    		))
    					);
    Page.RegisterClientScriptBlock(ResourcesHelper.Emoticon_Script,resscript);
  end;

end;


procedure Emoticon.Render(writer: HtmlTextWriter);
begin
  if Common.IsDesignTime(Page) then
    MoodImage.Visible := false
  else
    MoodDesignText.Visible := false;

  inherited;

end;
{$ENDREGION}














end.
